(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6272,        220]*)
(*NotebookOutlinePosition[      7114,        247]*)
(*  CellTagsIndexPosition[      7070,        243]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\ Example\ 2.3  .1 : \ 
        use\ 3 - point\ trapezoidal\ rule\ *) \[IndentingNewLine]\(k[x_, 
          s_] := \ x\ s\  - \ x^3\ s^3/6;\)\), "\[IndentingNewLine]", 
    \(\(x = {0, \ 1/2, \ 1};\)\), "\[IndentingNewLine]", 
    \(\(s = {0, \ 1/2, \ 1};\)\), "\[IndentingNewLine]", 
    \(matk = 
      Table[k[x[\([i]\)], \ s[\([j]\)]], \ {i, 3}, \ {j, 
          3}]\[IndentingNewLine]\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 95\/384, 23\/48}, {0, 23\/48, 5\/6}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/4, \ 0, 0}, \ {0, 1/2, 0}, \ {0, 0, 
            1/4}};\)\), "\[IndentingNewLine]", 
    \(a = matk . d\)}], "Input"],

Cell[BoxData[
    \({{0, 0, 0}, {0, 95\/768, 23\/192}, {0, 23\/96, 5\/24}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu] {{1, 0, 0}, \ {0, 1, 0}, {0, 0, 
              1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(-\[Mu]\), 0, 0}, {0, 95\/768 - \[Mu], 23\/192}, {0, 23\/96, 
        5\/24 - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b]\  \[Equal] \ 0, \ \[Mu]] // N\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] 
          0.`}, {\[Mu] \[Rule] \(-0.008600740911505061`\)}, {\[Mu] \[Rule] 
          0.3406319909115051`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[\[Mu]^2 - \ 13\ \[Mu]/42\  - 2/1575 \[Equal] 
        0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] \(-0.004049582339545647`\)}, {\[Mu] \[Rule] 
          0.3135733918633552`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearAll\)], "Input"],

Cell[BoxData[
    \(ClearAll\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\( (*\ 
      Use\ Gauss - Legendre\ rule\ for\ n = 
        2; \[IndentingNewLine]first\ compute\ weights\ and\ gausspoints\ for\ \
the\ interval\ \((0, 1)\)\ *) \)\(\[IndentingNewLine]\)\(LegendreP[2, 
      x]\)\)\)], "Input"],

Cell[BoxData[
    \(\(-\(1\/2\)\) + \(3\ x\^2\)\/2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NSolve[LegendreP[2, x]\  \[Equal] \ 0, \ x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] \(-0.5773502691896257`\)}, {x \[Rule] 
          0.5773502691896257`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(gausspoints = {\(-0.5773502691896257`\), \ 
          0.5773502691896257`};\)\), "\[IndentingNewLine]", 
    \(\(f[a_] := \ \((1.  + a)\)/2;\)\), "\[IndentingNewLine]", 
    \(newgausspoints = \ 
      Map[f, {\ \(-0.5773502691896257`\), \ 0.5773502691896257`}]\)}], "Input"],

Cell[BoxData[
    \({0.21132486540518713`, 0.7886751345948129`}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ These\ the\ gausspoints\ in\ the\ interval\ \((0, 
          1)\)\ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(k[x_, s_] := \ x\ s\  - \ x^3\ s^3/6;\)\), "\[IndentingNewLine]", 
    \(\(x = {0.21132486540518713`, 
          0.7886751345948129`};\)\), "\[IndentingNewLine]", 
    \(\(s = {0.21132486540518713`, 
          0.7886751345948129`};\)\), "\[IndentingNewLine]", 
    \(matk = 
      Table[k[x[\([i]\)], \ s[\([j]\)]\ ], {i, 2}, \ {j, 2}]\)}], "Input"],

Cell[BoxData[
    \({{0.044643354690320734`, 0.16589506172839508`}, {0.16589506172839508`, 
        0.5818998551862224`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(d = {{1/2, \ 0}, \ {0, \ 1/2}};\)\), "\[IndentingNewLine]", 
    \(a = matk . d\)}], "Input"],

Cell[BoxData[
    \({{0.022321677345160367`, 0.08294753086419754`}, {0.08294753086419754`, 
        0.2909499275931112`}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(c = \[Mu] {{1, 0}, \ {0, 1}};\)\), "\[IndentingNewLine]", 
    \(b = a - c\)}], "Input"],

Cell[BoxData[
    \({{\(\(0.022321677345160367`\)\(\[InvisibleSpace]\)\) - \[Mu], 
        0.08294753086419754`}, {0.08294753086419754`, \(\(0.2909499275931112`\
\)\(\[InvisibleSpace]\)\) - \[Mu]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[Det[b] \[Equal] 0, \ \[Mu]]\)], "Input"],

Cell[BoxData[
    \({{\[Mu] \[Rule] \(-0.0012267234332642644`\)}, {\[Mu] \[Rule] 
          0.31449832837153585`}}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ Similarly\ for\ n = \(3\ and\ n = 6\)\ *) \)], "Input"]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{547, 544},
WindowMargins->{{1, Automatic}, {Automatic, 1}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 427, 8, 107, "Input"],
Cell[2169, 61, 86, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2292, 67, 148, 3, 43, "Input"],
Cell[2443, 72, 88, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2568, 78, 143, 3, 43, "Input"],
Cell[2714, 83, 122, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2873, 90, 75, 1, 27, "Input"],
Cell[2951, 93, 158, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3146, 101, 41, 1, 27, "Input"],
Cell[3190, 104, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3269, 110, 105, 2, 27, "Input"],
Cell[3377, 114, 126, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3540, 121, 41, 1, 27, "Input"],
Cell[3584, 124, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3663, 130, 251, 5, 75, "Input"],
Cell[3917, 137, 64, 1, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4018, 143, 76, 1, 27, "Input"],
Cell[4097, 146, 116, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4250, 153, 298, 5, 91, "Input"],
Cell[4551, 160, 77, 1, 26, "Output"]
}, Open  ]],
Cell[4643, 164, 108, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[4776, 170, 372, 7, 75, "Input"],
Cell[5151, 179, 135, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5323, 186, 116, 2, 43, "Input"],
Cell[5442, 190, 135, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5614, 197, 111, 2, 43, "Input"],
Cell[5728, 201, 211, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5976, 209, 66, 1, 27, "Input"],
Cell[6045, 212, 128, 2, 26, "Output"]
}, Open  ]],
Cell[6188, 217, 80, 1, 27, "Input"]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

